/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, window */

'use strict';

define([ 'Portal', 'backbone', 'marionette', 'jquery', 'modules/subject-info/subjectInfoView', 'hbs!modules/infobar/infobar' ],
    function (Portal, Backbone, Marionette, $, SubjectInfoView, template) {
    return Backbone.Marionette.Layout.extend({
        template : template,
        regions : {
            searchIconRegion: "#patient-search",
            patientRegion: "#patient-context",
            userRegion: "#user-context",
            alertBadgeRegion: "#alert-badge"
         },
        initialize : function () {
            _.bindAll(this);
        },
        onShow : function () {
            this.$el.trigger('create');
        },
        events : {
            'tap #alerts-list': 'openAlertsList',
            'tap #user-menu': 'openMenu',
            'tap #patient-context div': 'openSubjectInfo',
            'keydown #context-wrapper div': 'openSubjectInfoKb',
            'tap #patient-info': 'openSubjectInfo'
        },
        openAlertsList : function (e) {
            e.preventDefault();
            Portal.execute("open-alerts-list");
            $(this.alertBadgeRegion.el).hide();
        },
        openMenu : function (e) {
            e.preventDefault();
            Portal.execute("open-user-menu");
        },
        openSubjectInfo : function(e) {
            e.preventDefault();
            Portal.execute("open-subject-info");
        },
        openSubjectInfoKb: function (e) {
            if (e.which === 13) {
                e.preventDefault();
                Portal.execute("open-subject-info");
            }
        },
		modelEvents: {
            "change" : "uberChanged"
        },
        uberChanged: function (e) {
            this.render();
            this.$el.trigger('create');
        }
    });
});
